/* sed.h -- types and constants for the stream editor */

/* data area sizes used by both modules */
#define MAXBUF          4000    /* maximum size of all buffers */
#define MAXAPPENDS      20      /* maximum number of appends */
#define MAXTAGS         9       /* tagged patterns are \1 to \9 */
#define MAXPLUS		50	/* maximum number of +n addresses*/

/* constants for compiled-command representation */
#define EQCMD   0x01    /* = -- print current line number               */
#define ACMD    0x02    /* a -- append text after current line  */
#define BCMD    0x03    /* b -- branch to label                         */
#define CCMD    0x04    /* c -- change current line             */
#define DCMD    0x05    /* d -- delete all of pattern space             */
#define CDCMD   0x06    /* D -- delete first line of pattern space      */
#define GCMD    0x07    /* g -- copy hold space to pattern space        */
#define CGCMD   0x08    /* G -- append hold space to pattern space      */
#define HCMD    0x09    /* h -- copy pattern space to hold space        */
#define CHCMD   0x0A    /* H -- append hold space to pattern space      */
#define ICMD    0x0B    /* i -- insert text before current line         */
#define LCMD    0x0C    /* l -- print pattern space in escaped form     */
#define NCMD    0x0D    /* n -- get next line into pattern space        */
#define CNCMD   0x0E    /* N -- append next line to pattern space       */
#define PCMD    0x0F    /* p -- print pattern space to output           */
#define CPCMD   0x10    /* P -- print first line of pattern space       */
#define QCMD    0x11    /* q -- exit the stream editor                  */
#define RCMD    0x12    /* r -- read in a file after current line */
#define SCMD    0x13    /* s -- regular-expression substitute           */
#define TCMD    0x14    /* t -- branch on last substitute successful    */
#define CTCMD   0x15    /* T -- branch on last substitute failed        */
#define WCMD    0x16    /* w -- write pattern space to file             */
#define CWCMD   0x17    /* W -- write first line of pattern space       */
#define XCMD    0x18    /* x -- exhange pattern and hold spaces         */
#define YCMD    0x19    /* y -- transliterate text                      */
#define BRCMD   0x20    /* { -- grouping command  */
#define NOCMD   0x21    /* Nop command*/

typedef struct  cmd_t                /* compiled-command representation */
{
        char    *addr1;                 /* first address for command */
        char    *addr2;                 /* second address for command */
        union
        {
                char            *lhs;   /* s command lhs */
                struct cmd_t    *link;  /* branch address */
        } u;
        char    command;                /* command code */
        char    *rhs;                   /* s command replacement string */
	FILE    *fout;                  /* associated output file descriptor */
        struct
        {
		unsigned nthone  :11;    /* if !0 only nth replace*/
                unsigned allbut  : 1;   /* was negation specified? */
                unsigned global  : 1;   /* was g postfix specified? */
                unsigned print   : 2;   /* was 1=p or 2=P postfix specified? */
                unsigned inrange : 1;   /* in the middle of an address range? */
        } flags;
}   sedcmd;         /* use this name for declarations */

/* address and regular expression compiled-form markers */
#define STAR    1       /* mark for closure  orred into single RE marker*/
#define CCHR    2       /* non-newline character to be matched follows */
#define CDOT    4       /* dot (any character) marker */
#define CCL     6       /* character class follows */
#define CNL     8       /* match line start */
#define CDOL    10      /* match line end */
#define CBRA    12      /* tagged pattern start marker */
#define CKET    14      /* tagged pattern end marker */
#define CBACK   16      /* backslash-digit pair marker */
#define CLNUM   18      /* numeric-address index follows */
#define CEND    20      /* symbol for end-of-line match */
#define CEOF    22      /* end-of-field mark end of RE*/
#define CPLUS   24 	/* plus address indexes follow*/
#define CBOW	26	/* begining of word test*/
#define CEOW 	28	/* end of word test*/
#define MTYPE   32      /* multiple counts orred into single RE marker*/
#define ARGMARK -128    /*mark a replaceable in REs */

#ifdef DEBUG
#define PASS(x) fprintf(stderr,"%s\n",x)
#else
#define PASS(x)
#endif
/* sed.h ends here */
